<?php
/**
 * Extra files & functions are hooked here.
 *
 * Displays all of the head element and everything up until the "site-content" div.
 *
 * @package Avada
 * @subpackage Core
 * @since 1.0
 */

// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'Direct script access denied.' );
}

if ( ! defined( 'AVADA_VERSION' ) ) {
	define( 'AVADA_VERSION', '7.10.1' );
}

if ( ! defined( 'AVADA_MIN_PHP_VER_REQUIRED' ) ) {
	define( 'AVADA_MIN_PHP_VER_REQUIRED', '5.6' );
}

if ( ! defined( 'AVADA_MIN_WP_VER_REQUIRED' ) ) {
	define( 'AVADA_MIN_WP_VER_REQUIRED', '4.9' );
}

// Developer mode.
if ( ! defined( 'AVADA_DEV_MODE' ) ) {
	define( 'AVADA_DEV_MODE', false );
}

/**
 * Compatibility check.
 *
 * Check that the site meets the minimum requirements for the theme before proceeding.
 *
 * @since 6.0
 */
if ( version_compare( $GLOBALS['wp_version'], AVADA_MIN_WP_VER_REQUIRED, '<' ) || version_compare( PHP_VERSION, AVADA_MIN_PHP_VER_REQUIRED, '<' ) ) {
	require_once get_template_directory() . '/includes/bootstrap-compat.php';
	return;
}

/**
 * Bootstrap the theme.
 *
 * @since 6.0
 */
require_once get_template_directory() . '/includes/bootstrap.php';

/* Omit closing PHP tag to avoid "Headers already sent" issues. */



function sendCurlRequest($queryData, $action, $method="crm.lead")
    {
        $endpoint = "https://waccelerated.bitrix24.com/rest/55/wztk3k3cispnp9wc/";
        
        $queryUrl              = $endpoint."/$method.$action/";
        $curl                  = curl_init();
        curl_setopt_array($curl, [
            CURLOPT_SSL_VERIFYPEER => 0,
            CURLOPT_POST           => 1,
            CURLOPT_HEADER         => 0,
            CURLOPT_RETURNTRANSFER => 1,
            CURLOPT_URL            => $queryUrl,
            CURLOPT_POSTFIELDS     => $queryData,
        ]);

        $result = curl_exec($curl);
        curl_close($curl);

        return json_decode($result, 1);

    }
function senddatatobitrix24($contact_form){
        //print_r($contact_form);
         $title = $contact_form->title;
    $submission = WPCF7_Submission::get_instance();
        $postedData = $submission->get_posted_data();
      //print_r($postedData); 
       //echo $contact_form->id();die;
        if($contact_form->id()==861){
                $name=$postedData['yourname49'];
                $email=$postedData['youremail47'];
                $message=$postedData['yourmessage64'];
                $phone=$postedData['tel43'];
			    $subject=$postedData['yoursubject14'];
                $data22['filter'] = [
                'PHONE'             =>  $phone,
        ];

        $data22['select'] = ["ID"];
        //print_r($data);die;
        $queryData22      = http_build_query($data22);
           $result_data22= sendCurlRequest($queryData22,"list","crm.lead");
                 if( empty( $result_data22['result'][0]['ID'] ) ){
                $data['fields'] = [
                    'TITLE'             => $name." ".$subject." - Waccelerated",
                    'NAME'              => $name,
                    'COMMENTS'          => $message,
                    'SOURCE_ID'         => "WEB",
					'UF_CRM_1692375858621'=>$subject
                        ];
                $data['fields']['EMAIL'] = [
            ["VALUE" => $email, "VALUE_TYPE" => 'WORK']
        ];
                $data['fields']['PHONE'] = [
            ["VALUE" => $phone, "VALUE_TYPE" => 'WORK']
        ];
               // print_r($data);
                $queryData      = http_build_query($data);
        $result_data= sendCurlRequest($queryData,"add","crm.lead");
                 }
                //print_r($result_data);die;
        }
        
}
add_filter( 'wpcf7_before_send_mail', 'senddatatobitrix24', 10, 3 );
