tinymce.PluginManager.add('pts_editattrs', function(editor) {
    var allowedAttr = ['id', 'class', 'style'];

    function getHtmlPanel() {
        var $newEl = jQuery('#ptsMceSubMenyAddHtmlAttr');
        $newMainEl = $newEl.clone().removeAttr('id');
        return $newMainEl[0].outerHTML;
    }

    editor.addButton('pts_editattrs', {
        type: 'panelbutton'
        ,	icon: 'fullpage'
        ,	tooltip: 'Edit attributes'
        ,	onclick: function(e) {}
        ,	stateSelector: 'a[href]'

        ,	panel: {
            role: 'application'
            ,	html: getHtmlPanel
            ,   isHasEvent: false
            ,	border: 1	// All other menus have border: 1 by default, this should look like same
            ,	onshow: function (e) {
                var control = jQuery('#' + e.control._id),
                    el = jQuery(editor.bodyElement),
                    panel = this;

                for(var i = 0; i < allowedAttr.length; i++) {
                    var input = control.find('label.ptsElMenuSubPanelRow[data-id=' + allowedAttr[i] + '] input');
                    input.eq(0).val(el.attr(allowedAttr[i]));
                    if(!panel.isHasEvent) {
                        input.eq(0).on('keyup', function(e) {
                            var me = jQuery(this),
                                attr = me.parent().eq(0).data('id'),
                                val = me.val();

                            el.attr(attr, val);
                        });
                    }
                }
                panel.isHasEvent = true;
            }
            ,	onhide: function(e) {}
        }
    });
});